/*
 * Decompiled with CFR 0.152.
 */
package app;

import javax.swing.JOptionPane;
import util.Config;
import util.Logger;

public class InputLine {
    static Logger logger = Logger.getLogger();
    private String separator = " ";
    private String comment = "#";
    private int posTimestamp = 0;
    private int posCategory = 1;
    private int posTarget = 2;
    private int posAzi = 3;
    private int posFreq = 4;
    private int posLevel = 5;
    private int posQuality = 6;
    private int posHeading = 7;
    private int posDeviation = 8;
    private int posDistance = 9;
    private int posSpeed = 10;
    private int posRoll = 11;
    private int posPitch = 12;
    private int posAltDiff = 13;
    private int posAntBase = 14;
    private int posRealX = 15;
    private int posRealY = 16;
    private int posImagX = 17;
    private int posImagY = 18;
    private String category;
    private double target;
    private double freq;
    private double azi;
    private double rx;
    private double ry;
    private double ix;
    private double iy;

    public String getCategory() {
        return this.category;
    }

    public double getTarget() {
        return this.target;
    }

    public double getFreq() {
        return this.freq;
    }

    public double getAzi() {
        return this.azi;
    }

    public double getRealX() {
        return this.rx;
    }

    public double getRealY() {
        return this.ry;
    }

    public double getImagX() {
        return this.ix;
    }

    public double getImagY() {
        return this.iy;
    }

    public InputLine(String line) {
        Config cfg = Config.getConfig();
        this.separator = cfg.getParam("Separator");
        this.comment = cfg.getParam("Comment");
        this.posCategory = cfg.getParamToInt("PosCategory");
        this.posTarget = cfg.getParamToInt("PosTarget");
        this.posFreq = cfg.getParamToInt("PosFreq");
        this.posAzi = cfg.getParamToInt("PosAzi");
        this.posRealX = cfg.getParamToInt("PosRealX");
        this.posRealY = cfg.getParamToInt("PosRealY");
        this.posImagX = cfg.getParamToInt("PosImagX");
        this.posImagY = cfg.getParamToInt("PosImagY");
        int currentPos = 0;
        if (!line.startsWith(this.comment)) {
            try {
                String[] strs = line.split(this.separator);
                currentPos = this.posCategory;
                this.category = strs[currentPos];
                currentPos = this.posTarget;
                this.target = Double.parseDouble(strs[currentPos]);
                currentPos = this.posFreq;
                this.freq = Double.parseDouble(strs[currentPos]);
                currentPos = this.posAzi;
                this.azi = Double.parseDouble(strs[currentPos]);
                if (strs.length >= this.posImagY) {
                    currentPos = this.posRealX;
                    this.rx = Double.parseDouble(strs[currentPos]);
                    currentPos = this.posRealY;
                    this.ry = Double.parseDouble(strs[currentPos]);
                    currentPos = this.posImagX;
                    this.ix = Double.parseDouble(strs[currentPos]);
                    currentPos = this.posImagY;
                    this.iy = Double.parseDouble(strs[currentPos]);
                } else {
                    this.rx = 0.0;
                    this.ry = 0.0;
                    this.ix = 0.0;
                    this.iy = 0.0;
                }
            }
            catch (Exception e) {
                String msg = "Cannot convert input " + e + "\n";
                msg = String.valueOf(msg) + "line = " + line + "\n";
                msg = String.valueOf(msg) + "at position " + currentPos;
                JOptionPane.showMessageDialog(null, msg);
                System.exit(0);
            }
        }
    }
}

